<?php
header("Content-Type: application/json");
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

try {
    // Fetch filters from GET parameters
    $statusfilter = isset($_GET['statusfilter']) ? $_GET['statusfilter'] : null;
    $searchIcon = isset($_GET['searchIcon']) ? $_GET['searchIcon'] : null;
    $datetimepickersearch = isset($_GET['datetimepickersearch']) ? $_GET['datetimepickersearch'] : null;
    $customdate = isset($_GET['customdate']) ? $_GET['customdate'] : null;

    // Base SQL query (without payment table join)
    $query = "SELECT 
                o.Order_id AS id,
                o.order_no AS orderid,
                i.invoice_no,
                o.time AS createdate,
                o.Grand_total AS total_amount,
                o.displayname,
                o.Store_status AS storestatus,
                o.Action_status AS orderstatus,
                o.Delivery_partner AS deliveredby,
                o.Deliveryby AS deliverystatus,
                o.Tracking_id,
                o.Delete_status AS status,
                o.Action_status AS actionstatus,
                o.Payment_status AS paymentstatus,
                o.Invoice_id AS invoiceid,
                o.prebooked,
                c.displayname AS customername, 
                c.phonenumber AS customercontact,
                c.saddress AS address,
                c.scity AS city,
                c.spincode AS pincode,
                od.Product_id,
                GROUP_CONCAT(p.Product_name SEPARATOR '|') AS product_names,
                GROUP_CONCAT(p.Product_image SEPARATOR '|') AS product_images,
                (SELECT COUNT(*) FROM order_data WHERE order_data.Order_id = o.Order_id AND order_data.Delete_status=0) AS total_products
            FROM orders o
            INNER JOIN customer c ON c.id = o.user_id
            LEFT JOIN invoice i ON i.order_id = o.Order_id 
            INNER JOIN order_data od ON od.Order_id = o.Order_id AND od.Delete_status = 0
            INNER JOIN product p ON p.Product_id = od.Product_id
            WHERE o.Delete_status = 0";

    // Apply filters (same as before)
    if (!empty($statusfilter)) {
        $query .= " AND o.Action_status = '" . mysqli_real_escape_string($conn, $statusfilter) . "'";
    }

    if (!empty($searchIcon)) {
        $query .= " AND (o.order_no LIKE '%" . mysqli_real_escape_string($conn, $searchIcon) . "%' 
                    OR o.displayname LIKE '%" . mysqli_real_escape_string($conn, $searchIcon) . "%')";
    }

    if (!empty($datetimepickersearch)) {
        $dates = explode(" - ", $datetimepickersearch);
        if (count($dates) === 2) {
            $start_date = mysqli_real_escape_string($conn, trim($dates[0]));
            $end_date = mysqli_real_escape_string($conn, trim($dates[1]));
            $query .= " AND o.time BETWEEN '$start_date' AND '$end_date'";
        }
    }

    if (!empty($customdate)) {
        $query .= " AND DATE(o.time) = '" . mysqli_real_escape_string($conn, $customdate) . "'";
    }

    $query .= " GROUP BY o.Order_id ORDER BY o.Order_id DESC";

    // Execute orders query
    $result = mysqli_query($conn, $query);

    if (!$result) {
        echo json_encode(["status" => "error", "message" => "Failed to fetch data", "error_detail" => mysqli_error($conn)]);
        exit;
    }

    $orders = [];
while ($row = mysqli_fetch_assoc($result)) {
    // Fetch payment details for this order
    $paymentQuery = "SELECT 
                        Payment_id,
                        Order_id,
                        Invoice_id,
                        customer_id,
                        Amount,
                        Payment_amount,
                        Payment_type,
                        refund_amount,
                        note,
                        Payment_date,
                        refund_date,
                        Reference_id
                    FROM payment 
                    WHERE Order_id = '" . mysqli_real_escape_string($conn, $row['id']) . "' 
                    AND Delete_status = 0";
    
    $paymentResult = mysqli_query($conn, $paymentQuery);
    $paymentData = [];
    
    // Initialize sum variables and first record data
    $totalPaymentAmount = 0;
    $totalRefundAmount = 0;
    $firstRecord = null;
    
    if ($paymentResult && mysqli_num_rows($paymentResult) > 0) {
        while ($paymentRow = mysqli_fetch_assoc($paymentResult)) {
            // Sum up the amounts
            $totalPaymentAmount += $paymentRow['Payment_amount'];
            $totalRefundAmount += $paymentRow['refund_amount'];
            
            // Store the first record details
            if ($firstRecord === null) {
                $firstRecord = $paymentRow;
            }
        }
        
        // Create single output record with summed amounts
        if ($firstRecord !== null) {
            $paymentData[] = [
                "order_id" => $firstRecord['Order_id'],
                "invoice_id" => $firstRecord['Invoice_id'],
                "customer_id" => $firstRecord['customer_id'],
                "payment_id" => $firstRecord['Payment_id'],
                "amount" => $firstRecord['Amount'],
                "payment_amount" => $totalPaymentAmount,
                "payment_type" => $firstRecord['Payment_type'],
                "note" => $firstRecord['note'],
                "payment_date" => $firstRecord['Payment_date'],
                "refund_date" => $firstRecord['refund_date'],
                "refund_amount" => $totalRefundAmount,
                "reference_id" => $firstRecord['Reference_id']
            ];
        }
    }

        $orders[] = [
            "id" => $row['id'],
            "orderid" => $row['orderid'],
            "invoiceno" => $row['invoice_no'] ?: "-",
            "createdate" => $row['createdate'],
            "total_amount" => $row['total_amount'],
            "displayname" => $row['displayname'],
            "storestatus" => $row['storestatus'],
            "orderstatus" => $row['orderstatus'],
            "deliveredby" => $row['deliveredby'],
            "trackingid" => $row['Tracking_id'],
            "dispathstatus" => $row['dispathstatus'],
            "status" => $row['status'],
            "actionstatus" => $row['actionstatus'],
            "paymentstatus" => $row['paymentstatus'],
            "invoiceid" => $row['invoiceid'],
            "customername" => $row['customername'],
            "customercontact" => $row['customercontact'],
                 "address" => !empty($row['address']) ? $row['address'] : null,
             "city" => !empty($row['city']) ? $row['city'] : null,
              "pincode" => !empty($row['pincode']) ? $row['pincode'] : null,
            "total_products" => $row['total_products'],
            "product_names" => explode('|', $row['product_names']),
            "product_images" => explode('|', $row['product_images']),
            "totalproductcount" => $row['total_products'],
            "prebooked" => $row['prebooked'],
            "payment_details" => $paymentData
        ];
    }

    // Return the results as JSON
    echo json_encode($orders);
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => "An error occurred", "error_detail" => $e->getMessage()]);
} finally {
    mysqli_close($conn);
}
?>